#ifndef RAISIN_EXAMPLE_PLUGIN_HPP_
#define RAISIN_EXAMPLE_PLUGIN_HPP_

#include "raisin_plugin/plugin.hpp"
#include "raisin_data_logger/raisin_data_logger.hpp"
#include "raisin_data_logger/raisin_timer.hpp"

namespace raisin
{

namespace plugin
{

class ExamplePlugin : public Plugin
{
  public:
    ExamplePlugin(
      raisim::World & worldHub, raisim::RaisimServer & serverHub,
      raisim::World & worldSim, raisim::RaisimServer & serverSim, GlobalResource & globalResource);

    ~ExamplePlugin();

    bool advance() final;
    raisim::HeightMap * raisimHeightMap_;
    Eigen::VectorXd gc_;
    Eigen::VectorXd gv_;
    Eigen::VectorXd linAccB_;
    Eigen::VectorXd angVelB_;
    Eigen::VectorXd quat_;

    double loopTime_;

    size_t logIdx_;
};
} // namespace plugin

} // namespace raisin

#endif // RAISIN_EXAMPLE_PLUGIN_HPP_