# raisin_grid_mapping

A plugin for terrain mapping that integrates seamlessly with Raisin.

<div>
  <img width=400 src='figure/grid_mapping.png'>
</div>

## Framework Overview

*raisin_grid_mapping* plugin requires two key pieces of information: (1) **point cloud data** in the robot's base frame and (2) **robot's position and orientation** in the global frame.

This plugin supports both simulation environments and real-world deployments.

It processes the data to construct a grid map, which is then transformed into a Raisim heightmap object.

### Point Cloud data
For **simulation purposes**, activate RaisimUnreal (on port 7000) to enable depth image streaming.

For deployments involving **real robots**, connect to an Intel RealSense D435 depth camera here for depth image streaming.

To enable depth image streaming, modify the Raisin configuration in ```raisin/raisin_raibo/config/params.yaml as``` follows:

```diff
 camera:
   use_depth:
-    value: false
+    value: true
     dtype: bool
```

### Robot's Position and Orientation
Utilize an additional plugin of the STATE_ESTIMATOR type to provide the necessary data.

### Visualization
The constructed heightmap is visualized in a separate Raisim world instance, which can be accessed through RaisimUnity or RaisimUnreal on port 8080.